require( "scripts/style.lua" );


local yes="yes" ;
local yesname="yes" ;
local no="no" ;	
local noname="no" ;	
local name="yesnobox";
    
if (gDialogTable.yeslabel) then
    yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
    no = gDialogTable.nolabel ;
end
if (gDialogTable.yesname) then
    yesname = gDialogTable.yesname;
end
if (gDialogTable.noname) then
    noname = gDialogTable.noname;
end

if (gDialogTable.name) then
    name = gDialogTable.name;
end


MakeDialog
{
    name=name, -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
        image="ui/surfaces/panel",
        x=kCenter,
        y=kCenter,

        SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
        Text
        {
            x=160,y=20,w=kMax,h=30,
            flags = kVAlignCenter + kHAlignLeft,
            name = "yesnotitle",
            label= gDialogTable.title,
        };
        
        SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
        Text
        {
            x=0,y=kCenter - 20,
            name = "yesnobody",
            label= gDialogTable.body,
        };

        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            command=
                function()
                    if (gDialogTable.yes) then 
                        gDialogTable.yes() ; 
                    end
                end;
            close = true,
            flags = 5,
            name = yesname,
            x = kCenter-80,
            y = kMax-100,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"yes", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"yes", 0, 0), 				
        },
        Button
        {
            command=
                function() 
                    if (gDialogTable.no) then
                        gDialogTable.no() ; 
                    end
                end;
            close = true,
            flags = 5,
            name = noname,
            x = kCenter+80,
            y = kMax-100,
            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"no", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"no", 0, 0), 				
        },
    },

} -- MakeDialog
